
from gurobipy import *

# Create a model
m = Model("Ice_Cream_Production")

# Define the decision variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Maple_Pecan_Batches")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Mint_Chocolate_Batches")

# Define the objective function
m.setObjective(400*x1 + 250*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(50*x1 + 30*x2 <= 8000, "Mixing_Machine_Time")
m.addConstr(80*x1 + 70*x2 <= 10000, "Freezing_Machine_Time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Maple Pecan Batches: {x1.x}")
    print(f"Mint Chocolate Batches: {x2.x}")
    print(f"Total Profit: ${400*x1.x + 250*x2.x:.2f}")
else:
    print("No optimal solution found")

