
from gurobipy import *

def solve_ice_cream_production():
    # Create a new model
    model = Model()

    # Define the decision variables
    x = model.addVar(name="maple_pecan_batches", lb=0, vtype=GRB.CONTINUOUS)
    y = model.addVar(name="mint_chocolate_batches", lb=0, vtype=GRB.CONTINUOUS)

    # Objective function: Maximize profit
    model.setObjective(400 * x + 250 * y, GRB.MAXIMIZE)

    # Constraints
    model.addConstr(50 * x + 30 * y <= 8000, name="mixing_machine_constraint")
    model.addConstr(80 * x + 70 * y <= 10000, name="freezing_machine_constraint")

    # Solve the model
    model.optimize()

    # Print the results
    if model.status == GRB.OPTIMAL:
        print(f"Optimal solution found. Production levels: {x.varValue} batches of maple pecan, {y.varValue} batches of mint chocolate.")
    else:
        print("No optimal solution found.")

solve_ice_cream_production()
