
import gurobipy as gp

# Create a new model
model = gp.Model("Electronics_Production")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="entry_level")
y = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="premium")

# Set objective function
model.setObjective(300*x + 200*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x <= 20, "entry_level_demand")
model.addConstr(y <= 15, "premium_demand")
model.addConstr(x + y <= 30, "total_sales")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of entry-level devices to sell: {x.x}")
    print(f"Number of premium devices to sell: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

