
from gurobipy import *

# Create a model
m = Model("Device_Sales")

# Define decision variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="entry_level_devices")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="premium_devices")

# Objective function: Maximize profit
m.setObjective(300*x + 200*y, GRB.MAXIMIZE)

# Constraints
m.addConstr(x <= 20, "max_entry_level_demand")
m.addConstr(y <= 15, "max_premium_demand")
m.addConstr(x + y <= 30, "total_devices_limit")

# Solve the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found. Sell {x.x} entry-level devices and {y.x} premium devices.")
else:
    print("No optimal solution found.")

print("Objective function value (profit):", m.objVal)
