
import gurobi

def solve_device_sales():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    E = model.addVar(lb=0, ub=20, name="Entry-level_devices")
    P = model.addVar(lb=0, ub=15, name="Premium_devices")

    # Objective: Maximize profit
    model.setObjective(300*E + 200*P, gurobi.GRB.MAXIMIZE)

    # Constraint: Total devices sold is at most 30
    model.addConstraint(E + P <= 30)

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Entry-level devices = {E.varValue}, Premium devices = {P.varValue}")
        print(f"Maximum profit: ${300*E.varValue + 200*P.varValue}")
    else:
        print("The model is infeasible")

solve_device_sales()
