
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("MoviePassOptimization")

# Create decision variables
r = model.addVar(lb=0, vtype=GRB.INTEGER, name="regular_passes")
p = model.addVar(lb=0, vtype=GRB.INTEGER, name="premium_passes")

# Set objective function
model.setObjective(40*r + 90*p, GRB.MAXIMIZE)

# Add constraints
model.addConstr(r + p <= 500, "total_passes")
model.addConstr(p >= 100, "min_premium")
model.addConstr(r >= 3*p, "regular_preference")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Profit: ${model.objVal:.2f}")
    print(f"Regular Passes: {r.x}")
    print(f"Premium Passes: {p.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

