
from gurobipy import *

# Create a new model
m = Model("Movie_Passes")

# Define variables
R = m.addVar(vtype=GRB.CONTINUOUS, name="Regular_Passes")
P = m.addVar(vtype=GRB.CONTINUOUS, name="Premium_Passes")

# Set objective function
m.setObjective(40*R + 90*P, GRB.MAXIMIZE)

# Add constraints
m.addConstr(R + P <= 500, "Total_Passes")
m.addConstr(P >= 100, "Minimum_Premium_Passes")
m.addConstr(R >= 3*P, "Regular_vs_Premium")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Regular Passes: {R.x}")
    print(f"Premium Passes: {P.x}")
    print(f"Total Profit: {40*R.x + 90*P.x}")
else:
    print("No optimal solution found")

