
import gurobipy as gp

# Create a new model
model = gp.Model("MovieTheatrePasses")

# Decision Variables
R = model.addVar(lb=0, name="Regular_Passes")
P = model.addVar(lb=0, name="Premium_Passes")

# Objective Function: Maximize profit
model.setObjective(40*R + 90*P, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(R + P <= 500, name="Total_Passes")
model.addConstr(P >= 100, name="Premium_Reserved")
model.addConstr(R >= 3*P, name="Demand_Preference")

# Solve the model
model.solve()

# Output solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution: Regular Passes = {R.varValue}, Premium Passes = {P.varValue}")
    print(f"Max Profit: ${40*R.varValue + 90*P.varValue}")
else:
    print("The model is infeasible.")
