
import gurobipy as gp

# Create a new model
model = gp.Model("CarProduction")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="race_cars")
y = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="regular_cars")

# Set objective function
model.setObjective(20000 * x + 10000 * y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x <= 3, "race_car_limit")
model.addConstr(y <= 5, "regular_car_limit")
model.addConstr(x + y <= 6, "safety_check_limit")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of race cars to produce: {x.x}")
    print(f"Number of regular cars to produce: {y.x}")
    print(f"Maximum profit: ${model.objVal}")
else:
    print("No solution found.")

