
from gurobipy import *

# Create a new model
m = Model("Car_Production")

# Create variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="race_cars")
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="regular_cars")

# Set objective function
m.setObjective(20000*x + 10000*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x <= 3, "max_race_cars")
m.addConstr(y <= 5, "max_regular_cars")
m.addConstr(x + y <= 6, "max_safety_checks")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Race cars: {x.x}")
    print(f"Regular cars: {y.x}")
    print(f"Total profit: ${20000*x.x + 10000*y.x}")
else:
    print("No optimal solution found")
