
import gurobi

def solve_production_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    R = model.addVar(lb=0, ub=3, name="Race_Cars")  # Number of race cars
    r = model.addVar(lb=0, ub=5, name="Regular_Cars")  # Number of regular cars

    # Objective function: Maximize profit
    model.setObjective(20000*R + 10000*r, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(R <= 3, name="Race_Car_Limit")
    model.addConstr(r <= 5, name="Regular_Car_Limit")
    model.addConstr(R + r <= 6, name="Safety_Check_Limit")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Race Cars = {R.varValue}, Regular Cars = {r.varValue}")
        print(f"Maximum profit: ${20000*R.varValue + 10000*r.varValue}")
    else:
        print("No optimal solution found.")

solve_production_problem()
