
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("VehicleProduction")

# Create decision variables
x = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="minivans")
y = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="trucks")

# Set objective function
model.setObjective(1200 * x + 1700 * y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(2 * x + 4 * y <= 12, "assembly_constraint")
model.addConstr(1.5 * x + 2 * y <= 11, "painting_constraint")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of minivans to produce: {x.x}")
    print(f"Number of trucks to produce: {y.x}")
    print(f"Maximum profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

