
from gurobipy import *

# Create a new model
m = Model("Kald_Vehicle_Optimization")

# Define the decision variables
M = m.addVar(name="Minivans", vtype=GRB.INTEGER, lb=0)
T = m.addVar(name="Trucks", vtype=GRB.INTEGER, lb=0)

# Set the objective function to maximize profit
m.setObjective(1200*M + 1700*T, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*M + 4*T <= 12, name="Assembly_Machine_Constraint")
m.addConstr(1.5*M + 2*T <= 11, name="Painting_Machine_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Minivans: {M.x}")
    print(f"Trucks: {T.x}")
    print(f"Total Profit: ${1200*M.x + 1700*T.x:.2f}")
else:
    print("No optimal solution found")
