
import gurobi

def solve_vehicle_production_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(name="minivans", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    y = model.addVar(name="trucks", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Maximize profit
    model.setObjective(1200*x + 1700*y, gurobi.GRB.MAXIMIZE)

    # Assembly machine constraint
    model.addConstr(2*x + 4*y <= 12, name="assembly_constraint")

    # Painting machine constraint
    model.addConstr(1.5*x + 2*y <= 11, name="painting_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal production levels: Minivans = {x.varValue}, Trucks = {y.varValue}")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("The problem is infeasible.")

if __name__ == "__main__":
    solve_vehicle_production_problem()
