
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("watch_production")

# Create variables
d = m.addVar(lb=0, vtype=GRB.INTEGER, name="digital_watches")
a = m.addVar(lb=0, vtype=GRB.INTEGER, name="analog_watches")

# Set objective function
m.setObjective(15 * d + 10 * a, GRB.MAXIMIZE)

# Add constraints
m.addConstr(d >= 150, "demand_digital")
m.addConstr(a >= 120, "demand_analog")
m.addConstr(d <= 200, "capacity_digital")
m.addConstr(a <= 180, "capacity_analog")
m.addConstr(d + a >= 300, "total_shipment")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Produce {d.x} digital watches")
    print(f"Produce {a.x} analog watches")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

