
from gurobipy import *

# Create a new model
m = Model("Watch_Production")

# Define variables
D = m.addVar(name="Digital_Watches", lb=150, ub=200)
A = m.addVar(name="Analog_Watches", lb=120, ub=180)

# Objective function: Maximize profit
m.setObjective(15*D + 10*A, GRB.MAXIMIZE)

# Constraint: Total shipment contract
m.addConstr(D + A >= 300, name="Total_Shipment")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution: Produce {D.x} digital watches and {A.x} analog watches.")
else:
    print("Model is infeasible or unbounded.")
