
import gurobi

def solve_watch_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    D = model.addVar(name="Digital_Watches")
    A = model.addVar(name="Analog_Watches")

    # Objective function: Maximize profit
    model.setObjective(15*D + 10*A, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(D >= 150, name="Digital_Demand")
    model.addConstr(A >= 120, name="Analog_Demand")
    model.addConstr(D <= 200, name="Digital_Production_Limit")
    model.addConstr(A <= 180, name="Analog_Production_Limit")
    model.addConstr(D + A >= 300, name="Contract_Obligation")

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal production levels: Digital = {D.varValue}, Analog = {A.varValue}")
        print(f"Max Profit: ${15*D.varValue + 10*A.varValue}")
    else:
        print("No optimal solution found.")

# Run the function
solve_watch_problem()
