
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("BakeryOptimization")

# Create decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="pancakes") # Number of pancake batches
y = m.addVar(vtype=GRB.CONTINUOUS, name="pretzels") # Number of pretzel batches

# Set objective function
m.setObjective(25*x + 50*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2.5*x + 1.5*y <= 65, "oven_time")
m.addConstr(0.5*x + 3*y <= 35, "pastry_chef_time")
m.addConstr(x >= 0, "pancakes_non_negative")  # Explicit non-negativity constraints
m.addConstr(y >= 0, "pretzels_non_negative")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of pancake batches: {x.x:.2f}")
    print(f"Number of pretzel batches: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

