
from gurobipy import *

# Create a new model
m = Model("Bakery_Optimization")

# Define variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="pancakes", lb=0)
y = m.addVar(vtype=GRB.CONTINUOUS, name="pretzels", lb=0)

# Set the objective function
m.setObjective(25*x + 50*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2.5*x + 1.5*y <= 65, "oven_time")
m.addConstr(0.5*x + 3*y <= 35, "pastry_chef_time")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Pancakes: {x.x}")
    print(f"Pretzels: {y.x}")
    print(f"Maximum Profit: ${25*x.x + 50*y.x:.2f}")
else:
    print("No optimal solution found")
