
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the decision variables
x1 = m.addVar(name="pancakes", lb=0, ub=None, obj=25)
x2 = m.addVar(name="pretzels", lb=0, ub=None, obj=50)

# Add the oven time constraint
m.addConstr(2.5 * x1 + 1.5 * x2 <= 65, name="oven_time")

# Add the pastry chef time constraint
m.addConstr(0.5 * x1 + 3 * x2 <= 35, name="pastry_chef_time")

# Set the model objective to maximize profit
m.setObjective(x1.obj * x1 + x2.obj * x2, gurobi.GRB.MAXIMIZE)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of batches of pancakes: {x1.x}")
    print(f"Number of batches of pretzels: {x2.x}")
    print(f"Maximum profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found.")
