
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("instrument_store")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="pianos") # Number of pianos
y = m.addVar(vtype=GRB.INTEGER, name="guitars") # Number of guitars

# Set objective function
m.setObjective(300*x + 200*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(8*x + 3*y <= 100, "space_constraint")
m.addConstr(500*x + 300*y <= 8000, "budget_constraint")
m.addConstr(y >= 0.3*(x + y), "guitar_proportion")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of pianos: {x.x}")
    print(f"Number of guitars: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

