
from gurobipy import *

# Create a new model
m = Model("Instrument_Store_Optimization")

# Define decision variables
pianos = m.addVar(name='pianos', vtype=GRB.INTEGER, lb=0)
guitars = m.addVar(name='guitars', vtype=GRB.INTEGER, lb=0)

# Objective function: Maximize profit
m.setObjective(300*pianos + 200*guitars, GRB.MAXIMIZE)

# Constraints
m.addConstr(8*pianos + 3*guitars <= 100, name='space_constraint')
m.addConstr(500*pianos + 300*guitars <= 8000, name='budget_constraint')
m.addConstr(0.7*guitars >= 0.3*pianos, name='guitar_percentage_constraint')

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {pianos.varName} = {pianos.x}, {guitars.varName} = {guitars.x}")
else:
    print("No optimal solution found")
