
import gurobi

def solve_instrument_store_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    P = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="Pianos")
    G = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="Guitars")

    # Objective function: Maximize profit
    model.setObjective(300*P + 200*G, gurobi.GRB.MAXIMIZE)

    # Space constraint
    model.addConstr(8*P + 3*G <= 100, name="Space_Constraint")

    # Budget constraint
    model.addConstr(500*P + 300*G <= 8000, name="Budget_Constraint")

    # Guitar percentage constraint
    model.addConstr(0.7*G >= 0.3*P, name="Guitar_Percentage_Constraint")

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found.")
        print(f"Pianos: {P.varValue}, Guitars: {G.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_instrument_store_problem()
