
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("PopcornMix")

# Create decision variables
x = m.addVar(lb=0, name="FamilyMix")  # Pounds of family mix
y = m.addVar(lb=0, name="PartyMix")  # Pounds of party mix

# Set objective function
m.setObjective(4.5 * x + 6 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.5 * x + 0.2 * y <= 35, "ButterPopcorn")
m.addConstr(0.5 * x + 0.8 * y <= 45, "CaramelPopcorn")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Family Mix: {x.x:.2f} pounds")
    print(f"Party Mix: {y.x:.2f} pounds")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

