
from gurobipy import *

# Create a model
m = Model("popcorn_mix")

# Define the decision variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="family_mix")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="party_mix")

# Set the objective function
m.setObjective(4.5*x1 + 6*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.5*x1 + 0.2*x2 <= 35, "butter_popcorn")
m.addConstr(0.5*x1 + 0.8*x2 <= 45, "caramel_popcorn")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Family mix: {x1.x} pounds")
    print(f"Party mix: {x2.x} pounds")
    print(f"Maximum profit: ${4.5*x1.x + 6*x2.x}")
else:
    print("No optimal solution found")

