
import gurobi

def solve_popcorn_problem():
    # Create a new model
    m = gurobi.Model()

    # Define variables
    F = m.addVar(name="Family_Mix", lb=0, ub=None)  # Pounds of family mix
    P = m.addVar(name="Party_Mix", lb=0, ub=None)   # Pounds of party mix

    # Objective function: Maximize profit
    m.setObjective(4.5 * F + 6 * P, gurobi.GRB.MAXIMIZE)

    # Constraints
    m.addConstr(0.5 * F + 0.2 * P <= 35, name="Butter_Popcorn_Constraint")
    m.addConstr(0.5 * F + 0.8 * P <= 45, name="Caramel_Popcorn_Constraint")

    # Solve the problem
    m.optimize()

    # Print the solution
    if m.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Family Mix: {F.varValue} pounds")
        print(f"Party Mix: {P.varValue} pounds")
        print(f"Max Profit: ${m.objVal:.2f}")
    else:
        print("The problem is infeasible.")

solve_popcorn_problem()
