
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Gary's Diet")

# Create variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="noodles")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cakes")

# Set objective function
m.setObjective(3*x + 5*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x + 4*y <= 100, "protein_constraint")
m.addConstr(12*x + 8*y <= 30, "mineral_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Cost: ${m.objVal:.2f}")
    print(f"Number of noodle servings: {x.x:.2f}")
    print(f"Number of cake servings: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

