
from gurobipy import *

# Create a new model
m = Model("Gary_Diet")

# Define the decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="noodles")
y = m.addVar(vtype=GRB.CONTINUOUS, name="cakes")

# Set the objective function to minimize cost
m.setObjective(3*x + 5*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x + 4*y <= 100, "protein_constraint")
m.addConstr(12*x + 8*y <= 30, "mineral_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Servings of noodles: {x.x}")
    print(f"Servings of cakes: {y.x}")
    print(f"Total cost: ${3*x.x + 5*y.x:.2f}")
else:
    print("No optimal solution found")
