
import gurobi

def solve_diet_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    N = model.addVar(name="noodles", lb=0, ub=gurobi.GRB.INFINITY)
    C = model.addVar(name="cakes", lb=0, ub=gurobi.GRB.INFINITY)

    # Define the objective function
    model.setObjective(3*N + 5*C, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(5*N + 4*C <= 100, name="proteins_constraint")
    model.addConstr(12*N + 8*C <= 30, name="minerals_constraint")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal Solution:")
        print(f"Noodles: {N.varValue}")
        print(f"Cakes: {C.varValue}")
        print(f"Cost: {model.objVal}")
    else:
        print("The model is infeasible or unbounded.")

solve_diet_problem()
