
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("investment_optimization")

    # Create variables
    x = m.addVar(name="housing_investment")  # Housing investment
    y = m.addVar(name="roads_investment")  # Roads investment


    # Set objective function
    m.setObjective(0.95 * x + 0.32 * y, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(x + y <= 3500, "budget_constraint")
    m.addConstr(x >= 750, "min_housing_constraint")
    m.addConstr(y >= 0.24 * (x + y), "min_roads_constraint")


    # Optimize model
    m.optimize()

    # Check for infeasibility
    if m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print(f"Optimal housing investment: ${x.x:.2f}")
        print(f"Optimal roads investment: ${y.x:.2f}")
        print(f"Optimal total profit: ${m.objVal:.2f}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
