
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    R = model.addVar(lb=0, name="Roads")  # Investment in roads
    H = model.addVar(lb=750, name="Housing")  # Investment in housing

    # Objective function: Maximize profit
    model.setObjective(0.95 * H + 0.32 * R, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(R + H <= 3500, name="Budget")  # Total investment not exceeding $3500
    model.addConstr(R >= (6/19) * H, name="Roads_vs_Housing")  # Minimum roads investment

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal investment in roads: ${R.varValue:.2f}")
        print(f"Optimal investment in housing: ${H.varValue:.2f}")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_investment_problem()
