
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("TrainAcrossCanada")

# Create variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="sleeper_tickets") # Integer since you can't sell fractions of tickets
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="regular_tickets")

# Set objective function
m.setObjective(500*x + 200*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 400, "capacity")
m.addConstr(y >= 5*x, "preference")
m.addConstr(x >= 50, "min_sleeper")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Sleeper class tickets: {x.x}")
    print(f"Regular tickets: {y.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

