
from gurobipy import *

# Create a model
m = Model("TrainAcrossCanada")

# Define decision variables
S = m.addVar(vtype=GRB.INTEGER, name="sleeper_class_tickets")
R = m.addVar(vtype=GRB.INTEGER, name="regular_tickets")

# Set the objective function to maximize profit
m.setObjective(500*S + 200*R, GRB.MAXIMIZE)

# Add constraints
m.addConstr(S + R <= 400, "total_passengers")
m.addConstr(S >= 50, "sleeper_class_minimum")
m.addConstr(R >= 5*S + 1, "regular_vs_sleeper_ratio")

# Solve the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Maximum Profit: ", m.objVal)
    print("Sleeper Class Tickets Sold: ", S.x)
    print("Regular Tickets Sold: ", R.x)
else:
    print("Model is infeasible")
