
import gurobi

def train_across_canada():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x_s = model.addVar(lb=0, name="Sleeper_Class_Tickets")
    x_r = model.addVar(lb=0, name="Regular_Tickets")

    # Objective function: Maximize profit
    model.setObjective(500 * x_s + 200 * x_r, gurobi.GRB.MAXIMIZE)

    # Total capacity constraint
    model.addConstr(x_s + x_r <= 400, name="Total_Capacity")

    # Preference constraint
    model.addConstr(x_r >= 5 * x_s, name="Preference_Constraint")

    # Sleeper class reservation constraint
    model.addConstr(x_s >= 50, name="Sleeper_Class_Reservation")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution:")
        print(f"Sleeper Class Tickets: {x_s.varValue}")
        print(f"Regular Tickets: {x_r.varValue}")
        print(f"Maximum Profit: {model.objVal}")
    else:
        print("The model is infeasible.")

train_across_canada()
