
import gurobipy as gp

# Create a new model
m = gp.Model("Wine Promotion Optimization")

# Create decision variables
x = m.addVar(vtype=gp.GRB.CONTINUOUS, name="Package_A")  # Package A
y = m.addVar(vtype=gp.GRB.CONTINUOUS, name="Package_B")  # Package B


# Set objective function
m.setObjective(120 * x + 200 * y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2 * x + 2 * y <= 1000, "Red Wine Constraint")
m.addConstr(x + 3 * y <= 800, "White Wine Constraint")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of Package A: {x.x:.2f}")
    print(f"Number of Package B: {y.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

