
from gurobipy import *

# Create a new model
m = Model("Wine_Promotion")

# Define variables
x_A = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Package_A")
x_B = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Package_B")

# Objective function: Maximize profit
m.setObjective(120*x_A + 200*x_B, GRB.MAXIMIZE)

# Red wine constraint
m.addConstr(2*x_A + 2*x_B <= 1000, "Red_Wine_Constraint")
# Simplified version of the red wine constraint (not necessary to add both)
# m.addConstr(x_A + x_B <= 500, "Simplified_Red_Wine_Constraint")

# White wine constraint
m.addConstr(x_A + 3*x_B <= 800, "White_Wine_Constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Package A: {x_A.x}")
    print(f"Package B: {x_B.x}")
    print(f"Maximum Profit: ${120*x_A.x + 200*x_B.x:.2f}")
else:
    print("No optimal solution found")
