
import gurobi as grb

def solve_wine_promotion_problem():
    model = grb.Model()

    x = model.addVar(obj=120, name="Package_A", vtype=grb.GRB.CONTINUOUS)
    y = model.addVar(obj=200, name="Package_B", vtype=grb.GRB.CONTINUOUS)

    model.addConstr(2*x + 2*y <= 1000, name="red_wine")
    model.addConstr(x + 3*y <= 800, name="white_wine")
    model.addConstr(x >= 0, name="x_non_negative")
    model.addConstr(y >= 0, name="y_non_negative")

    model.setObjective(x + y, grb.GRB.MAXIMIZE)

    model.optimize()

    if model.status == grb.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Package A: {x.varValue}")
        print(f"Package B: {y.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_wine_promotion_problem()
