
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("wood_factory")

# Create decision variables
x = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="lumbers")
y = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="plywood")

# Set objective function
model.setObjective(10*x + 35*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(3*x + 2*y <= 2500, "worker_hours")
model.addConstr(8*x + 12*y <= 4000, "machine_hours")
model.addConstr(x >= 200, "min_lumbers")
model.addConstr(y >= 300, "min_plywood")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of lumbers: {x.x}")
    print(f"Number of plywood: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

