
from gurobipy import *

# Create a new model
m = Model("Wood_Factory_Optimization")

# Define the decision variables
L = m.addVar(vtype=GRB.INTEGER, name="Lumbers", lb=200)  # At least 200 lumbers
P = m.addVar(vtype=GRB.INTEGER, name="Plywoods", lb=300)  # At least 300 plywoods

# Set the objective function: Maximize profit
m.setObjective(10*L + 35*P, GRB.MAXIMIZE)

# Add constraints
# Worker-hours constraint
m.addConstr(3*L + 2*P <= 2500, name="Worker_Hours")

# Machine-hours constraint
m.addConstr(8*L + 12*P <= 4000, name="Machine_Hours")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Lumbers to produce: {L.x}")
    print(f"Plywoods to produce: {P.x}")
    print(f"Maximum profit: ${10*L.x + 35*P.x}")
else:
    print("No optimal solution found. The model is infeasible.")

