
import gurobipy as gp

# Create a new model
model = gp.Model("Wood_Factory_Optimization")

# Define the decision variables with minimum production requirements
L = model.addVar(lb=200, name="Lumbers")
P = model.addVar(lb=300, name="Plywood")

# Objective function: Maximize profit
model.setObjective(10*L + 35*P, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(3*L + 2*P <= 2500, name="Worker_hours")
model.addConstr(8*L + 12*P <= 4000, name="Machine_hours")

# Solve the model
model.solve()

# Output the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found: L = {L.varValue}, P = {P.varValue}")
    print(f"Maximum profit: ${10*L.varValue + 35*P.varValue}")
else:
    print("No optimal solution found.")
