
import gurobipy as gp

# Create a new model
m = gp.Model("cruise_ship_optimization")

# Create decision variables
x = m.addVar(name="long_term_tickets", lb=0, vtype=gp.GRB.INTEGER) # Integer number of tickets
y = m.addVar(name="week_long_tickets", lb=0, vtype=gp.GRB.INTEGER)

# Set objective function
m.setObjective(500*x + 150*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 1500, "capacity")
m.addConstr(x >= 35, "min_long_term")
m.addConstr(y >= 4*x, "week_long_preference")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of long-term tickets: {x.x}")
    print(f"Number of week-long tickets: {y.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status: {m.status}")

