
from gurobipy import *

# Create a new model
m = Model("Cruise_Ticket_Optimization")

# Define decision variables
L = m.addVar(vtype=GRB.INTEGER, name="Long-term_Tickets")
W = m.addVar(vtype=GRB.INTEGER, name="Week-long_Tickets")

# Set the objective function: Maximize profit
m.setObjective(500*L + 150*W, GRB.MAXIMIZE)

# Add constraints
m.addConstr(L + W <= 1500, "Total_Capacity")
m.addConstr(L >= 35, "Minimum_Long-term_Tickets")
m.addConstr(W >= 4*L, "Preference_Ratio")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Long-term Tickets: {L.x}")
    print(f"Week-long Tickets: {W.x}")
    print(f"Maximum Profit: ${500*L.x + 150*W.x}")
else:
    print("No optimal solution found")
