
import gurobi

def solve_cruise_ship_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(lb=35, name="long_term_tickets")  # Minimum of 35 long-term tickets
    y = model.addVar(name="week_long_tickets")

    # Objective function: Maximize profit
    model.setObjective(500 * x + 150 * y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x + y <= 1500, name="capacity_constraint")
    model.addConstr(y >= 4 * x, name="preference_constraint")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: Long-term tickets = {x.varValue:.0f}, Week-long tickets = {y.varValue:.0f}")
        print(f"Maximum Profit: ${500 * x.varValue + 150 * y.varValue:.0f}")
    else:
        print("The model is infeasible.")

solve_cruise_ship_problem()
