
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("farm_investment")

# Create variables
x = m.addVar(name="x", lb=0)  # Investment in Bob's farm
y = m.addVar(name="y", lb=0)  # Investment in Joe's farm

# Set objective function
m.setObjective(0.08 * x + 0.06 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 50000, "total_investment")
m.addConstr(x >= 3 * y, "investment_ratio")
m.addConstr(x <= 40000, "bobs_farm_limit")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal investment in Bob's farm: ${x.x}")
    print(f"Optimal investment in Joe's farm: ${y.x}")
    print(f"Maximum earnings: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

