
from gurobipy import *

# Create a new model
m = Model("Investment_Optimization")

# Define the decision variables
x = m.addVar(lb=0, name="Bob's_Farm")  # Amount invested in Bob's farm
y = m.addVar(lb=0, name="Joe's_Farm")  # Amount invested in Joe's farm

# Define the objective function: Maximize earnings
m.setObjective(0.08*x + 0.06*y, GRB.MAXIMIZE)

# Define the constraints
m.addConstr(x + y <= 50000, "Total_Investment")
m.addConstr(x >= 3*y, "Bob_vs_Joe")
m.addConstr(x <= 40000, "Max_Bob")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: Invest ${x.x:.2f} in Bob's farm and ${y.x:.2f} in Joe's farm.")
else:
    print("No optimal solution found. The problem might be infeasible.")

# Print the objective function value
print(f"Maximum earnings: {m.objVal:.2f}")
