
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(name="investment_in_bobs_farm", lb=0)
    y = model.addVar(name="investment_in_joes_farm", lb=0)

    # Objective function: maximize earnings
    model.setObjective(0.08 * x + 0.06 * y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x + y <= 50000, name="total_investment")
    model.addConstr(x >= 3 * y, name="bob_to_joe_ratio")
    model.addConstr(x <= 40000, name="bobs_farm_max_investment")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal investment in Bob's farm: ${x.varValue:.2f}")
        print(f"Optimal investment in Joe's farm: ${y.varValue:.2f}")
        print(f"Maximized earnings: ${0.08 * x.varValue + 0.06 * y.varValue:.2f}")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    solve_investment_problem()
