
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("dog_food")

# Create variables
x = m.addVar(lb=0, name="x") # Type A food (kg)
y = m.addVar(lb=0, name="y") # Type B food (kg)

# Set objective function
m.setObjective(2*x + 5*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(x + 3*y >= 12, "meat_req")
m.addConstr(2*x + y >= 8, "micronutrient_req")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Type A food: {x.x:.2f} kg")
    print(f"Type B food: {y.x:.2f} kg")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

