
from gurobipy import *

# Create a new model
m = Model("Dog_Food_Optimization")

# Define the decision variables
x_A = m.addVar(vtype=GRB.CONTINUOUS, name="Type_A", lb=0)
x_B = m.addVar(vtype=GRB.CONTINUOUS, name="Type_B", lb=0)

# Set the objective function
m.setObjective(2*x_A + 5*x_B, GRB.MINIMIZE)

# Add constraints
m.addConstr(1*x_A + 3*x_B >= 12, "Meat_Requirement")
m.addConstr(2*x_A + 1*x_B >= 8, "Micronutrients_Requirement")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Type A dog food: {x_A.x} kg")
    print(f"Type B dog food: {x_B.x} kg")
    print(f"Total cost: ${m.objVal}")
else:
    print("No optimal solution found")
