
import gurobi

def solve_dog_food_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x_A = model.addVar(lb=0, name="Type_A_food")
    x_B = model.addVar(lb=0, name="Type_B_food")

    # Define the objective function
    model.setObjective(2 * x_A + 5 * x_B, gurobi.GRB.MINIMIZE)

    # Add the constraints
    model.addConstr(x_A + 3 * x_B >= 12, name="meat_constraint")
    model.addConstr(2 * x_A + x_B >= 8, name="micronutrients_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal cost: {model.objVal}")
        print(f"Type A food: {x_A.x}, Type B food: {x_B.x}")
    else:
        print("The problem is infeasible")

solve_dog_food_problem()
