
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("tool_manufacturing")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="drills")  # Number of drill packages
y = m.addVar(vtype=GRB.CONTINUOUS, name="saws")  # Number of saw packages

# Set objective function
m.setObjective(35*x + 100*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x + 30*y <= 800, "milling_constraint")
m.addConstr(70*x + 90*y <= 800, "cng_constraint")
m.addConstr(x >= 0, "x_nonneg")
m.addConstr(y >= 0, "y_nonneg")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Drill Packages (x): {x.x}")
    print(f"Number of Saw Packages (y): {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

